/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.Properties;
import tiled.core.TileSet;

public class Tile {
    private Image internalImage;
    private Image scaledImage;
    private int id = -1;
    protected int tileImageId = -1;
    private int groundHeight;
    private int tileOrientation;
    private double myZoom = 1.0;
    private Properties properties;
    private TileSet tileset;

    public Tile() {
        this.properties = new Properties();
    }

    public Tile(TileSet set) {
        this();
        this.setTileSet(set);
    }

    public Tile(Tile t) {
        this.properties = (Properties)t.properties.clone();
        this.tileImageId = t.tileImageId;
        this.tileset = t.tileset;
        if (this.tileset != null) {
            this.scaledImage = this.getImage().getScaledInstance(-1, -1, 1);
        }
    }

    public void setId(int i) {
        if (i >= 0) {
            this.id = i;
        }
    }

    public void setImage(Image i) {
        if (this.tileset != null) {
            this.tileset.overlayImage(this.tileImageId, i);
        } else {
            this.internalImage = i;
        }
    }

    public void setImage(int id) {
        this.tileImageId = id;
    }

    public void setImageOrientation(int orientation) {
        this.tileOrientation = orientation;
    }

    public void setTileSet(TileSet set) {
        if (this.tileset != null && this.tileset != set) {
            this.setImage(set.addImage(this.getImage()));
        } else if (this.internalImage != null) {
            this.setImage(set.addImage(this.internalImage));
            this.internalImage = null;
        }
        this.tileset = set;
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getId() {
        return this.id;
    }

    public int getGid() {
        if (this.tileset != null) {
            return this.id + this.tileset.getFirstGid();
        }
        return this.id;
    }

    public TileSet getTileSet() {
        return this.tileset;
    }

    public void drawRaw(Graphics g, int x, int y, double zoom) {
        Image img = this.getScaledImage(zoom);
        if (img != null) {
            g.drawImage(img, x, y - img.getHeight(null), null);
        }
    }

    public void draw(Graphics g, int x, int y, double zoom) {
        int gnd_h = (int)((double)this.groundHeight * zoom);
        this.drawRaw(g, x, y - gnd_h, zoom);
    }

    public int getWidth() {
        if (this.tileset != null) {
            Dimension d = this.tileset.getImageDimensions(this.tileImageId);
            return d.width;
        }
        if (this.internalImage != null) {
            return this.internalImage.getWidth(null);
        }
        return 0;
    }

    public int getHeight() {
        if (this.tileset != null) {
            Dimension d = this.tileset.getImageDimensions(this.tileImageId);
            return d.height;
        }
        if (this.internalImage != null) {
            return this.internalImage.getHeight(null);
        }
        return 0;
    }

    public int getImageId() {
        return this.tileImageId;
    }

    public int getImageOrientation() {
        return this.tileOrientation;
    }

    public Image getImage() {
        if (this.tileset != null) {
            return this.tileset.getImageById(this.tileImageId);
        }
        return this.internalImage;
    }

    public Image getScaledImage(double zoom) {
        if (zoom == 1.0) {
            return this.getImage();
        }
        if (zoom == this.myZoom && this.scaledImage != null) {
            return this.scaledImage;
        }
        Image img = this.getImage();
        if (img != null) {
            this.scaledImage = img.getScaledInstance((int)((double)this.getWidth() * zoom), (int)((double)this.getHeight() * zoom), 4);
            MediaTracker mediaTracker = new MediaTracker(new Canvas());
            mediaTracker.addImage(this.scaledImage, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException ie) {
                System.err.println(ie);
            }
            mediaTracker.removeImage(this.scaledImage);
            this.myZoom = zoom;
            return this.scaledImage;
        }
        return null;
    }

    public String toString() {
        return "Tile " + this.id + " (" + this.getWidth() + "x" + this.getHeight() + ")";
    }
}

